/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.datagen.betternether.worldgen;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.world.level.biome.Biome;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeBuilder;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeRegistry;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.api.v3.datagen.TagDataProvider;
import org.betterx.betternether.BetterNether;
import org.betterx.betternether.world.NetherBiome;
import org.betterx.betternether.world.NetherBiomeBuilder;
import org.betterx.betternether.world.NetherBiomeConfig;
import org.betterx.betternether.world.biomes.CrimsonGlowingWoods;
import org.betterx.betternether.world.biomes.CrimsonPinewood;
import org.betterx.betternether.world.biomes.FloodedDeltas;
import org.betterx.betternether.world.biomes.NetherBoneReef;
import org.betterx.betternether.world.biomes.NetherGrasslands;
import org.betterx.betternether.world.biomes.NetherGravelDesert;
import org.betterx.betternether.world.biomes.NetherJungle;
import org.betterx.betternether.world.biomes.NetherMagmaLand;
import org.betterx.betternether.world.biomes.NetherMushroomForest;
import org.betterx.betternether.world.biomes.NetherMushroomForestEdge;
import org.betterx.betternether.world.biomes.NetherPoorGrasslands;
import org.betterx.betternether.world.biomes.NetherSoulPlain;
import org.betterx.betternether.world.biomes.NetherSulfuricBoneReef;
import org.betterx.betternether.world.biomes.NetherSwampland;
import org.betterx.betternether.world.biomes.NetherSwamplandTerraces;
import org.betterx.betternether.world.biomes.NetherWartForest;
import org.betterx.betternether.world.biomes.NetherWartForestEdge;
import org.betterx.betternether.world.biomes.OldFungiwoods;
import org.betterx.betternether.world.biomes.OldSwampland;
import org.betterx.betternether.world.biomes.OldWarpedWoods;
import org.betterx.betternether.world.biomes.UpsideDownForest;
import org.betterx.betternether.world.biomes.UpsideDownForestCleared;
import org.betterx.datagen.betternether.NetherRegistrySupplier;
import org.betterx.worlds.together.tag.v3.TagManager;
import org.betterx.worlds.together.tag.v3.TagRegistry;

public class NetherBiomesDataProvider
extends TagDataProvider<Biome> {
    private static Set<BCLBiome> BIOMES = new HashSet<BCLBiome>();
    private static final BCLBiome BIOME_GRAVEL_DESERT = NetherBiomesDataProvider.registerNetherBiome(Config.BIOME_GRAVEL_DESERT);
    private static final BCLBiome BIOME_NETHER_JUNGLE = NetherBiomesDataProvider.registerNetherBiome(Config.BIOME_NETHER_JUNGLE);
    private static final BCLBiome BIOME_WART_FOREST = NetherBiomesDataProvider.registerNetherBiome(Config.BIOME_WART_FOREST, Config.BIOME_WART_FOREST_EDGE);
    private static final BCLBiome BIOME_GRASSLANDS = NetherBiomesDataProvider.registerNetherBiome(Config.BIOME_GRASSLANDS);
    private static final BCLBiome BIOME_MUSHROOM_FOREST = NetherBiomesDataProvider.registerNetherBiome(Config.BIOME_MUSHROOM_FOREST, Config.BIOME_MUSHROOM_FOREST_EDGE);
    private static final BCLBiome BIOME_MUSHROOM_FOREST_EDGE = BIOME_MUSHROOM_FOREST.getEdge();
    private static final BCLBiome BIOME_WART_FOREST_EDGE = BIOME_WART_FOREST.getEdge();
    private static final BCLBiome BIOME_BONE_REEF = NetherBiomesDataProvider.registerNetherBiome(Config.BIOME_BONE_REEF);
    private static final BCLBiome BIOME_SULFURIC_BONE_REEF = NetherBiomesDataProvider.registerSubBiome(Config.BIOME_SULFURIC_BONE_REEF, BIOME_BONE_REEF);
    private static final BCLBiome BIOME_POOR_GRASSLANDS = NetherBiomesDataProvider.registerSubBiome(Config.BIOME_POOR_GRASSLANDS, BIOME_GRASSLANDS);
    private static final BCLBiome NETHER_SWAMPLAND = NetherBiomesDataProvider.registerNetherBiome(Config.NETHER_SWAMPLAND);
    private static final BCLBiome NETHER_SWAMPLAND_TERRACES = NetherBiomesDataProvider.registerSubBiome(Config.NETHER_SWAMPLAND_TERRACES, NETHER_SWAMPLAND);
    private static final BCLBiome MAGMA_LAND = NetherBiomesDataProvider.registerNetherBiome(Config.MAGMA_LAND);
    private static final BCLBiome SOUL_PLAIN = NetherBiomesDataProvider.registerSubBiome(Config.SOUL_PLAIN, BIOME_WART_FOREST);
    private static final BCLBiome CRIMSON_GLOWING_WOODS = NetherBiomesDataProvider.registerSubBiome(Config.CRIMSON_GLOWING_WOODS, BiomeAPI.CRIMSON_FOREST_BIOME);
    private static final BCLBiome OLD_WARPED_WOODS = NetherBiomesDataProvider.registerSubBiome(Config.OLD_WARPED_WOODS, BiomeAPI.WARPED_FOREST_BIOME);
    private static final BCLBiome CRIMSON_PINEWOOD = NetherBiomesDataProvider.registerSubBiome(Config.CRIMSON_PINEWOOD, BiomeAPI.CRIMSON_FOREST_BIOME);
    private static final BCLBiome OLD_FUNGIWOODS = NetherBiomesDataProvider.registerSubBiome(Config.OLD_FUNGIWOODS, BIOME_MUSHROOM_FOREST);
    private static final BCLBiome FLOODED_DELTAS = NetherBiomesDataProvider.registerSubBiome(Config.FLOODED_DELTAS, BiomeAPI.BASALT_DELTAS_BIOME);
    private static final BCLBiome UPSIDE_DOWN_FOREST = NetherBiomesDataProvider.registerNetherBiome(Config.UPSIDE_DOWN_FOREST);
    private static final BCLBiome UPSIDE_DOWN_FOREST_CLEARED = NetherBiomesDataProvider.registerNetherBiome(Config.UPSIDE_DOWN_FOREST_CLEARED);
    private static final BCLBiome OLD_SWAMPLAND = NetherBiomesDataProvider.registerSubBiome(Config.OLD_SWAMPLAND, NETHER_SWAMPLAND);

    public NetherBiomesDataProvider(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
        super((TagRegistry)TagManager.BIOMES, List.of("betternether"), output, registriesFuture);
    }

    private static NetherBiome registerNetherBiome(NetherBiomeConfig config) {
        NetherBiome biome = NetherBiomeBuilder.create(config);
        BIOMES.add(biome);
        return biome;
    }

    private static NetherBiome registerNetherBiome(NetherBiomeConfig config, NetherBiomeConfig edgeConfig) {
        NetherBiome edge = NetherBiomeBuilder.create(edgeConfig);
        NetherBiome biome = NetherBiomeBuilder.create(config, edge);
        BIOMES.add(biome);
        BIOMES.add(edge);
        return biome;
    }

    private static NetherBiome registerSubBiome(NetherBiomeConfig config, BCLBiome mainBiome) {
        NetherBiome biome = NetherBiomeBuilder.createSubBiome(config, mainBiome);
        BIOMES.add(biome);
        return biome;
    }

    public static void bootstrap(BootstapContext<Biome> ctx) {
        BCLBiomeBuilder.registerUnbound(ctx);
        NetherRegistrySupplier.INSTANCE.MAIN_LOCK.release();
        BetterNether.LOGGER.info("Registered Biomes");
    }

    public static void bootstrapBCL(BootstapContext<BCLBiome> ctx) {
        for (BCLBiome biome : BIOMES) {
            ctx.m_255272_(biome.getBCLBiomeKey(), (Object)biome);
        }
        BetterNether.LOGGER.info("Registered BCLBiomes: " + BCLBiomeRegistry.BUILTIN_BCL_BIOMES.m_13562_());
    }

    public static void ensureStaticallyLoaded() {
    }

    static {
        try {
            NetherRegistrySupplier.INSTANCE.MAIN_LOCK.acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static class Config {
        private static final NetherBiomeConfig BIOME_GRAVEL_DESERT = new NetherGravelDesert.Config("Gravel Desert");
        private static final NetherBiomeConfig BIOME_NETHER_JUNGLE = new NetherJungle.Config("Nether Jungle");
        private static final NetherBiomeConfig BIOME_WART_FOREST = new NetherWartForest.Config("Wart Forest");
        private static final NetherBiomeConfig BIOME_GRASSLANDS = new NetherGrasslands.Config("Nether Grasslands");
        private static final NetherBiomeConfig BIOME_MUSHROOM_FOREST = new NetherMushroomForest.Config("Nether Mushroom Forest");
        private static final NetherBiomeConfig BIOME_MUSHROOM_FOREST_EDGE = new NetherMushroomForestEdge.Config("Nether Mushroom Forest Edge");
        private static final NetherBiomeConfig BIOME_WART_FOREST_EDGE = new NetherWartForestEdge.Config("Wart Forest Edge");
        private static final NetherBiomeConfig BIOME_BONE_REEF = new NetherBoneReef.Config("Bone Reef");
        private static final NetherBiomeConfig BIOME_SULFURIC_BONE_REEF = new NetherSulfuricBoneReef.Config("Sulfuric Bone Reef");
        private static final NetherBiomeConfig BIOME_POOR_GRASSLANDS = new NetherPoorGrasslands.Config("Poor Nether Grasslands");
        private static final NetherBiomeConfig NETHER_SWAMPLAND = new NetherSwampland.Config("Nether Swampland");
        private static final NetherBiomeConfig NETHER_SWAMPLAND_TERRACES = new NetherSwamplandTerraces.Config("Nether Swampland Terraces");
        private static final NetherBiomeConfig MAGMA_LAND = new NetherMagmaLand.Config("Magma Land");
        private static final NetherBiomeConfig SOUL_PLAIN = new NetherSoulPlain.Config("Soul Plain");
        private static final NetherBiomeConfig CRIMSON_GLOWING_WOODS = new CrimsonGlowingWoods.Config("Crimson Glowing Woods");
        private static final NetherBiomeConfig OLD_WARPED_WOODS = new OldWarpedWoods.Config("Old Warped Woods");
        private static final NetherBiomeConfig CRIMSON_PINEWOOD = new CrimsonPinewood.Config("Crimson Pinewood");
        private static final NetherBiomeConfig OLD_FUNGIWOODS = new OldFungiwoods.Config("Old Fungiwoods");
        private static final NetherBiomeConfig FLOODED_DELTAS = new FloodedDeltas.Config("Flooded Deltas");
        private static final NetherBiomeConfig UPSIDE_DOWN_FOREST = new UpsideDownForest.Config("Upside Down Forest");
        private static final NetherBiomeConfig UPSIDE_DOWN_FOREST_CLEARED = new UpsideDownForestCleared.Config("upside_down_forest_cleared");
        private static final NetherBiomeConfig OLD_SWAMPLAND = new OldSwampland.Config("Old Swampland");

        private Config() {
        }
    }
}

